Imports System.Windows.Forms

Public Class Procedural
    Inherits Form

    ' Symbolic constants for events
    Public DIRTY_EVENT As Integer = 1
    Public APPLY_EVENT As Integer = 2
    Public SAVE_EVENT As Integer = 3
    Public REVERT_EVENT As Integer = 4

    ' Symbolic constants for states
    Private BOTH_DIRTY As Integer = 101
    Private FILE_DIRTY As Integer = 102
    Private PARAM_DIRTY As Integer = 103
    Private NOT_DIRTY As Integer = 104

    Private applyButton As Button = Nothing
    Private saveButton As Button = Nothing
    Private revertButton As Button = Nothing

    Private state As Integer = NOT_DIRTY

    Friend Sub New()
        [Text] = "Parameter Editor"
        gotoState(NOT_DIRTY)
    End Sub 'New

    ' respond to events based on the current state.
    ' event - An event code.
    Public Sub processDirtyStateEvent(ByVal e As Integer)
        Select Case state
            Case BOTH_DIRTY
                procBothDirty(e)
            Case FILE_DIRTY
                procFileDirty(e)
            Case PARAM_DIRTY
                procParamDirty(e)
            Case Else
                Throw New System.ApplicationException("Unknown state event " & e)
        End Select
    End Sub 'processDirtyStateEvent

    ' processDirtyStateEvent(int)
    ' Set current state and perform entry actions for the state
    Public Sub gotoState(ByVal newState As Integer)
        Select Case newState
            Case NOT_DIRTY
                applyButton.Enabled = False
                revertButton.Enabled = False
                saveButton.Enabled = False
            Case FILE_DIRTY
                applyButton.Enabled = False
                revertButton.Enabled = True
                saveButton.Enabled = True
            Case BOTH_DIRTY
                applyButton.Enabled = True
                revertButton.Enabled = True
                saveButton.Enabled = True
            Case PARAM_DIRTY
                applyButton.Enabled = True
                revertButton.Enabled = False
                saveButton.Enabled = False
        End Select
        state = newState
    End Sub 'gotoState

    Private Function saveParam() As Boolean
        '...
        Return True
    End Function 'saveParam

    Private Function applyParam() As Boolean
        '...
        Return True
    End Function 'applyParam

    Private Function revertParam() As Boolean
        '...
        Return True
    End Function 'revertParam

    Private Sub procBothDirty(ByVal e As Integer)
        Select Case e
            Case DIRTY_EVENT
                ' Do nothing
            Case APPLY_EVENT
                If applyParam() Then
                    gotoState(FILE_DIRTY)
                End If
            Case SAVE_EVENT
                If saveParam() Then
                    gotoState(PARAM_DIRTY)
                End If
            Case REVERT_EVENT
                If revertParam() Then
                    gotoState(PARAM_DIRTY)
                End If
            Case Else
                Throw New System.ApplicationException("unexpected event " & e)
        End Select
    End Sub 'procBothDirty

    Private Sub procFileDirty(ByVal e As Integer)
        Select Case e
            Case DIRTY_EVENT
                gotoState(BOTH_DIRTY)
            Case SAVE_EVENT
                If saveParam() Then
                    gotoState(NOT_DIRTY)
                End If
            Case REVERT_EVENT
                If revertParam() Then
                    gotoState(PARAM_DIRTY)
                End If
            Case Else
                Throw New System.ApplicationException("unexpected event " & e)
        End Select
    End Sub 'procFileDirty

    Private Sub procParamDirty(ByVal e As Integer)
        Select Case e
            Case DIRTY_EVENT
                gotoState(BOTH_DIRTY)
            Case APPLY_EVENT
                If applyParam() Then
                    gotoState(NOT_DIRTY)
                End If
            Case Else
                Throw New System.ApplicationException("unexpected event " & e)
        End Select
    End Sub
End Class 'Procedural 
